/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.network.message;

import com.github.tartaricacid.netmusic.inventory.CDBurnerMenu;
import com.github.tartaricacid.netmusic.inventory.ComputerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SetMusicIDMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SetMusicIDMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"set_music_id"));
    public static final StreamCodec<ByteBuf, SetMusicIDMessage> STREAM_CODEC = StreamCodec.composite(ItemMusicCD.SongInfo.STREAM_CODEC, SetMusicIDMessage::getSong, SetMusicIDMessage::new);
    private final ItemMusicCD.SongInfo song;

    public SetMusicIDMessage(ItemMusicCD.SongInfo song) {
        this.song = song;
    }

    public static void handle(SetMusicIDMessage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                AbstractContainerMenu menu;
                Player patt0$temp = context.player();
                if (!(patt0$temp instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = sender.containerMenu;
                if (patt1$temp instanceof CDBurnerMenu) {
                    menu = (CDBurnerMenu)patt1$temp;
                    menu.setSongInfo(message.song);
                    return;
                }
                AbstractContainerMenu patt2$temp = sender.containerMenu;
                if (patt2$temp instanceof ComputerMenu) {
                    menu = (ComputerMenu)patt2$temp;
                    menu.setSongInfo(message.song);
                }
            });
        }
    }

    public ItemMusicCD.SongInfo getSong() {
        return this.song;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

